* Title: 	figure4.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of persistence in joblessness rate


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure4, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma PrimeMaleD UnempB perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 1980 Census and 2009-2011 ACS
keep if year == 1980 | (year>=2009 & year<=2011)

* Pool data for 2009-2011 ACS
replace year = 2010 if year>=2009 & year<=2011

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Fix coding due to post-2006 PUMA change due to Katrina
replace conspuma = 172 if conspuma == 173


*******************************************************************************
* (2) Construct jobless rate for 1980/2010
*******************************************************************************

collapse (sum) Total = PrimeMaleD Jobless = UnempB [pw=perwt], by(year statefip conspuma)
gen double Jobless_Rate = 100 * Jobless/Total
keep year conspuma statefip Jobless_Rate 
reshape wide Jobless_Rate, i(conspuma statefip) j(year) 

* Save dataset
compress
save output/figures/dta/figure4.dta, replace

* Generate Correlation
corr Jobless_Rate2010 Jobless_Rate1980

* Generate Regression
reg Jobless_Rate2010 Jobless_Rate1980, cluster(statefip)

*******************************************************************************
* (3) Produce graph
*******************************************************************************

scatter Jobless_Rate2010 Jobless_Rate1980 || lfit Jobless_Rate2010 Jobless_Rate1980, ///
		legend(label(1 "PUMA") label(2 "Best Fit")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Not Working Rate, 1980") ytitle("Not Working Rate, 2010")
		
graph save output/figures/gph/figure4, replace
graph export output/figures/eps/figure4.eps, as(eps) replace
export excel using output/figures/xlsx/figure4.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
